% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/StableFeatures.R
\name{StableFeatures}
\alias{StableFeatures}
\title{StableFeatures Function}
\usage{
StableFeatures(
  data_object,
  group_oi = NULL,
  cvThreshold = NULL,
  donorThreshold = NULL,
  housekeeping_genes = NULL,
  groupThreshold = NULL,
  topFeatures = 25,
  filePATH = NULL,
  fileName = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation
information and expression data from Bulk or single cell data.}

\item{group_oi}{Group of interest to focus on. Example among celltypes focus
on selected ones. Default is NULL.}

\item{cvThreshold}{Coefficient of variation threshold to select variable and
stable genes Default is 10 for single cell RNA \code{(100*SD/mean)}}

\item{donorThreshold}{Donor threshold number to be used, Default is number of
participants}

\item{housekeeping_genes}{Optional list of housekeeping genes to focus on.
Default is ACTB, GAPDH}

\item{groupThreshold}{Group label threshold number to be used, Default is
\code{(number of participants x group labels)/2}}

\item{topFeatures}{Number of features to be selected from each group, Default
is 25}

\item{filePATH}{User-defined output directory path to load the CV result obtained
from cvCalcSC function}

\item{fileName}{User defined filename}
}
\value{
PALMO object with stable (stable_genes) features
}
\description{
This function allows user to identify stable genes in participants across
longitudinal timepoints using single cell expression data. The coefficient of
variation (CV) calculated using \code{cvCalcSC} function. Users can identify
cvThreshold in different datasets using housekeeping genes CV distribution.
}
\examples{
\dontrun{
palmo_obj <- StableFeatures(data_object=palmo_obj, cvThreshold=10)
}
}
\keyword{StableFeatures}
