% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/longitudinalmfuzz.R
\name{longitudinalmfuzz}
\alias{longitudinalmfuzz}
\title{longitudinalmfuzz Function}
\usage{
longitudinalmfuzz(
  data_object,
  group_column = "group",
  timeColumn = "Time",
  timeOrder = NULL,
  donorColumn = "PTID",
  baseline_timepoint = NULL,
  featurelist = NULL,
  group_oi = NULL,
  mfuzz_thres = 0.25,
  mfuzz_min.std = 0,
  max_cluster = NULL,
  delta = 0.5,
  plotsize = 10,
  cl = 2,
  fileName = NULL,
  filePATH = NULL
)
}
\arguments{
\item{data_object}{Input \emph{PALMO} S4 object. It contains annotation information
and expression data from Bulk or single cell data.}

\item{group_column}{User-defined group name like 'group','celltype'}

\item{timeColumn}{User-defined time column name like 'Time'}

\item{timeOrder}{(Optional) User-defined order of time variable like
('D1','D2','D3')}

\item{donorColumn}{User-defined donor/participant column name like 'PTID'}

\item{baseline_timepoint}{(Optional) If baseline donors known (like 'PTID1')}

\item{featurelist}{(Optional) User-defined genes/features of interest}

\item{group_oi}{User-defined groups to consider for example from celltypes
select few}

\item{mfuzz_thres}{\code{mfuzz:thres} threshold for excluding genes}

\item{mfuzz_min.std}{\code{mfuzz:min.std} threshold for minimum standard
deviation}

\item{max_cluster}{Number of clusters to explore (Default 2^n)}

\item{delta}{\code{mfuzz:delta} threshold for minimum standard deviation}

\item{plotsize}{Size of plot width and height. Default 10 (in).}

\item{cl}{Number of clusters. Use nCores-1 to run parallel. Default 2}

\item{fileName}{User-defined file name, Default outputFile}

\item{filePATH}{User-defined output directory \emph{PATH} Default, current
directory}
}
\value{
longitudinal trajectory dataframe
}
\description{
This function allows you to identify gene/feature trajectory over
longitudinal points. The function uses mfuzz package (for more information
refer to https://www.bioconductor.org/packages/release/bioc/html/Mfuzz.html)
}
\examples{
\dontrun{
longitudinalmfuzz(data_object=palmo_obj, group_column='group',
timeColumn='Time', donorColumn='PTID')
}
}
\keyword{longitudinalmfuzz}
