% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decimateWavFiles.R
\name{decimateWavFiles}
\alias{decimateWavFiles}
\title{Decimate Wave Files}
\usage{
decimateWavFiles(inDir, outDir, newSr, progress = TRUE)
}
\arguments{
\item{inDir}{directory of wave files to decimate. Can also be a single .wav file.}

\item{outDir}{directory to write wave files to}

\item{newSr}{sample rate to decimate the files to}

\item{progress}{logical flag to show progress bar}
}
\value{
Invisibly returns the names of all files that were successfully
  decimated
}
\description{
Decimate a folder of .wav files or a single .wav file
  to a new sample rate.
}
\details{
This code is based on R code written by Jay Barlow.
}
\examples{

# one 20kHz wav file is included in package test data
origDir <- system.file('extdata', package='PAMmisc')
decDir <- file.path(tempdir(), 'decSR')
decWavs <- decimateWavFiles(origDir, decDir, 10000)
file.remove(decWavs)

}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
