% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculateModuleData.R
\name{calculateModuleData}
\alias{calculateModuleData}
\title{Run Custom Calculations on Pamguard Module Data}
\usage{
calculateModuleData(
  binData,
  binFuns = list(ClickDetector = list(standardClickCalcs)),
  settings = NULL
)
}
\arguments{
\item{binData}{Pamguard binary data as read in by
\code{\link[PamBinaries]{loadPamguardBinaryFile}}}

\item{binFuns}{A named list of functions to run on each Pamguard module.
Currently supported modules are 'ClickDetector' and 'WhistlesMoans', a
sample input for binFuns would be list('ClickDetector'=list(clickFun1,
clickFun2), 'WhistlesMoans'=list(wmFun1))}

\item{settings}{a list of settings from a Pamguard XML file}
}
\value{
A data frame with one row for each channel of each detection.
  Each row will have the UID, channel number, and name of the detector.
  Clicks of different classifications are treated as different detectors
  for this purpose, with the classification label number appended to the
  detector name. The number of columns will depend on the results of the
  calculations from the supplied binFuns.
}
\description{
Run a list of custom calculations on a Pamguard binary
  file.
}
\author{
Taiki Sakai \email{taiki.sakai@noaa.gov}
}
