% Generated by roxygen2 (4.0.2): do not edit by hand
\name{panic10}
\alias{panic10}
\title{PANIC (2010) Sample Moment and PAC tests for Idiosyncratic Component}
\usage{
panic10(x, nfac, k1, jj, demean)
}
\arguments{
\item{x}{A NxT matrix containing the data}

\item{nfac}{An integer specifying the maximum number of factors allowed
while estimating the factor model.}

\item{k1}{The maximum lag allowed in the ADF test.}

\item{jj}{an Integer 1 through 8. Choices 1 through 7 are respectively, IC(1),
IC(2), IC(3), AIC(1), BIC(1), AIC(3), and BIC(3), respectively. Choosing 8
makes the number of factors equal to the number of columns whose sum of
eigenvalues is less than  or equal to .5.}

\item{demean}{logical argument. If TRUE, function performs tests on demeaned
data. If FALSE, uses non-demeanded data generating process.}
}
\value{
rho1 Estimation of the Pooled Autoregressive Coefficient.

Model This function shows MP models A, B, and C. A assumes no deterministic component.
B assumes a constant and allows for a fixed effect model. C allows a constant
and trend.

test.A.B A matrix containing t_a, t_b, t_a1, and t_a2.

test.C.P A matrix containing the Pooled tests as well as Model C.

extra.test a matrix containing t_c, rho1, adf30b.
Or a matrix containing t_c, rho1, and the LM test for PANIC (2004)'s
Idiosyncratic Components.

pa-pb Pooled test from PANIC (2010). Null of nonstationarity.
If both reject conclude stationarity. However, if only one rejects the panel
is nonstationary.

PMSB Unit root test tends to zero. The unit root hypothesis is rejected
in favor of stationarity when the PMSB test goes below a critical value.
}
\description{
This function performs the tests of PANIC (2010).
One estimates the pooled autoregressive coefficient, and one uses a sample
moment. The sample moments test is based off of the modified
Sargan-Bhargava test (PMSB).
}
\references{
Bai, Jushan, and Serena Ng.
"Panel Unit Root Tests With Cross-Section Dependence: A Further Investigation."
Econometric Theory 26.04 (2010): 1088-1114. Print.
}

