% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{descriptives}
\alias{descriptives}
\title{Compute descriptive statistics for a variable in the metabolic data set}
\usage{
descriptives(dataset, variable, group = NULL)
}
\arguments{
\item{dataset}{the dataset to analyze}

\item{variable}{character scalar giving the variable name to summarize}

\item{group}{character scalar giving an optional grouping variable for the
summary}
}
\description{
Compute descriptive statistics for a variable in the metabolic data set
}
\examples{
data(ex_data, package = "PAutilities")
ex_data$group_var <- rep(
 c("One", "Two", "Three"),
 each = ceiling(nrow(ex_data)/3)
)[seq(nrow(ex_data))]
descriptives(ex_data, "Axis1", "group_var")

}
