\name{locatePolys}
\alias{locatePolys}
\title{Locate Polygons on the Current Plot}
\description{
  Locate polygons on the current plot (using the \code{\link{locator}}
  function).
}
\usage{
locatePolys (pdata, n = 512, type = "o", \dots)
}
\arguments{
  \item{pdata}{\link{PolyData} (\emph{optional}) with
    columns \code{PID} and \code{SID} (\emph{optional}), with two more
    optional columns \code{n} and \code{type}.}
  \item{n}{maximum number of points to locate.}
  \item{type}{one of \code{"n"}, \code{"p"}, \code{"l"}, or
    \code{"o"}. If \code{"p"} or \code{"o"}, then the points are
    plotted; if \code{"l"}  or \code{"o"}, then the points are joined by
    lines.}
  \item{\dots}{additional \code{\link{par}} parameters for the
    \code{\link{locator}} function.}
}
\details{
  This function allows its user to define polygons with mouse clicks on
  the current plot via the \code{\link{locator}} function.  The
  arguments \code{n} and \code{type} are the usual parameters for the
  \code{\link{locator}} function, but the user can specify them for each
  individual (\code{PID}, \code{SID}) in a \code{pdata} object.

  If a \code{pdata} object exists, the function ignores columns other
  than \code{PID}, \code{SID}, \code{n}, and \code{type}.  If \code{pdata}
  includes \code{n}, then an outer boundary has \code{n > 0} and an
  inner boundary has \code{n < 0}.

  On exit from \code{\link{locator}}, suppose the user defined \emph{m}
  vertices for a given polygon. For that polygon, the \code{X} and
  \code{Y} columns will contain \code{NA}s where \code{POS =
  (}\emph{m}\code{+1):n} for outer-boundaries and \code{POS =
  (|n|-}\emph{m}\code{):1} for inner-boundaries.  The
  \code{\link{na.omit}} function can remove rows with \code{NA}s.

  If a \code{pdata} object does not exist, the output contains only one
  polygon with a \code{PID} equal to 1.  One inner-boundary polygon
  (\code{POS} goes from \code{n} to \code{1}) can be generated by
  supplying a negative \code{n}.

  If \code{type = "o"} or \code{type = "l"}, the function draws a line
  connecting the last and first vertices.
}
\value{
  \link{PolySet} with \code{projection} attribute equal to the map's
  projection.  The function does not set the \code{zone} attribute.
}
\author{
  \href{https://academic.macewan.ca/boersn/}{Nicholas M. Boers}, Associate Professor -- Computer Science\cr
  MacEwan University, Edmonton AB\cr
  Last modified \code{Rd: 2007-06-06}
}
\seealso{
  \code{\link{addPolys}},
  \code{\link{appendPolys}},
  \code{\link{clipPolys}},
  \code{\link{closePolys}},
  \code{\link{findCells}},
  \code{\link{findPolys}},
  \code{\link{fixPOS}},
  \code{\link{joinPolys}},
  \code{\link{plotMap}},
  \code{\link{plotPolys}},
  \code{\link{thickenPolys}},
  \code{\link{thinPolys}}.
}
\examples{
#--- define one polygon with up to 5 vertices on the current plot
\dontrun{polys <- locatePolys(n = 5)}
}
\keyword{iplot}
