% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mathWtsEfrontRiskyMuCov.R
\name{mathWtsEfrontRiskyMuCov}
\alias{mathWtsEfrontRiskyMuCov}
\title{Efficient Frontier Portfolio Weights Vectors}
\usage{
mathWtsEfrontRiskyMuCov(muRet, volRet, corrRet, mu.efront, digits = NULL)
}
\arguments{
\item{muRet}{Vector of asset mean returns}

\item{volRet}{Vector of asset volatilities}

\item{corrRet}{Asset correlation matrix}

\item{mu.efront}{A vector of specified efficient frontier mean returns}

\item{digits}{Integer number of significant digits with default NULL}
}
\value{
A matrix whose first row contains the mean returns along the efficient
frontier, the second row contains the corresponding volatilities, and the
remaining rows contain the components of the corresponding weight vectors.
}
\description{
Same as function \code{"mathWtsEfrontRisky"} except that
instead a user specified time series of portfolio asset returns, it is
based on user specified returns mean vector and covariance matrix
}
\examples{
args(mathWtsEfrontRiskyMuCov)
}
