% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/psea2mass.R
\name{psea2mass}
\alias{psea2mass}
\title{Translate PSEA results for Mass Spectrometry searching tools}
\usage{
psea2mass(x, sig.level = 0.05, number.rep = NULL)
}
\arguments{
\item{x}{A list of psea results generated by \code{runPSEA} function.}

\item{sig.level}{The significance level to filter PTMs (applies on adjusted
p-value). Default value is 0.05}

\item{number.rep}{Only consider PTM terms that occurred more than a specific
number of times in UniProt. This number is set by number.rep parameter. The
default value is NULL.}
}
\value{
A database of subset of protein modifications:
\itemize{
\item id: a unique identification for each subset of protein modifications, PSI-MOD.
\item name: the name of modification.
\item def: definition of PSI-MOD definition
}
}
\description{
This function translates protein set enrihment analysis results
and extracts the required information for mass spectometry searching tools.
The subset of protein modifications is from
\url{https://raw.githubusercontent.com/HUPO-PSI/psi-mod-CV/master/PSI-MOD.obo}.
}
\examples{
# We recommend at least nperm = 1000.
# The number of permutations was reduced to 10
# to accommodate CRAN policy on examples (run time <= 5 seconds).
psea_res <- runPSEA(protein = exmplData2, os.name = 'Rattus norvegicus (Rat)', nperm = 10)
MS <- psea2mass(x = psea_res, sig.level = 0.05)
}
