% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.flirti.R
\name{summary.flirti}
\alias{summary.flirti}
\title{Summary Method for flirti Objects}
\usage{
\method{summary}{flirti}(object, ...)
}
\arguments{
\item{object}{An object of class "flirti".}

\item{...}{Not applicable}
}
\value{
Prints a 5 number summary of the beta values, delta, OptM, and Optlambda
}
\description{
Summarizes the values of an object of class "flirti".
}
\examples{
library(fda)
betaind = 1
snr  = 2
nsim = 200
n    = 50
p    = 21
Y = array(NA,c(n,nsim))
X = array(NA,c(n,p,nsim))
domain = c(0,1)
lambda = seq(0.0005,0.01,length.out = 10)
Mf = 6:13
extra=list(Mf=Mf,lambda=lambda)

for(itersim in 1:nsim)
{
  dat = ngr.data.generator.bsplines(n=n,nknots=64,norder=4,p=p,domain=domain,snr=snr,betaind=1)
 Y[,itersim]  = dat$Y
  X[,,itersim] = dat$X
}


fltyfit = FLiRTI(Y=Y[1:n,1],(X[1:n,,1]),d=3,cons=4,domain=domain,extra=extra)

summary(fltyfit)


}
