% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Byars.R
\name{byars_upper}
\alias{byars_upper}
\title{byars_upper}
\usage{
byars_upper(x, confidence = 0.95)
}
\arguments{
\item{x}{the observed numbers of events; numeric vector; no default}

\item{confidence}{the required level of confidence expressed as a number between 0.9 and 1
or 90 and 100; numeric; default 0.95}
}
\value{
Returns upper confidence limits for observed numbers of events using Byar's method [1]
}
\description{
Calculates the upper confidence limits for observed numbers of events using Byar's method [1].
}
\section{Notes}{
 \code{\link{byars_lower}} and \code{byars_upper} together return symmetric confidence
 intervals around counts, therefore
 for a specified confidence level, \eqn{\alpha}, the probability that, by chance, the upper limit returned
 will be below the true underlying value, is \eqn{\alpha}/2.
}

\examples{
byars_upper(65)
byars_upper(65,99.8)

}
\references{
[1] Breslow NE, Day NE. Statistical methods in cancer research,
 volume II: The design and analysis of cohort studies. Lyon: International
 Agency for Research on Cancer, World Health Organisation; 1987.
}
\seealso{
Other PHEindicatormethods package functions: \code{\link{byars_lower}},
  \code{\link{phe_dsr}}, \code{\link{phe_isr}},
  \code{\link{phe_mean}}, \code{\link{phe_proportion}},
  \code{\link{phe_rate}}, \code{\link{phe_smr}},
  \code{\link{wilson_lower}}, \code{\link{wilson_upper}}
}
