% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pllk.R
\name{pllk}
\alias{pllk}
\title{Partial likelihood for proportional hazards}
\usage{
pllk(beta, xmat, ind, cc = NULL)
}
\arguments{
\item{beta}{parameter vector}

\item{xmat}{regression matrix}

\item{ind}{censoring indicator, 1 for event and any other value otherwise.}

\item{cc}{Continuity correction for sum of x vectors with multiple occurrences in risk set.  For binary covariates is half.  Default a vector of zeros.}
}
\value{
a list with components
\itemize{
  \item d0 partial likelihood
  \item d1 first derivative vector
  \item d2 second derivative matrix
}
}
\description{
Partial likelihood for proportional hazards
}
\examples{
#Uses data set breast from package coxphf.
data(breast)
 xmat<-as.matrix(breast)[order(breast$TIME),c("T","N")]
 ind<-breast$CENS[order(breast$TIME)]
 short<-coxph(Surv(TIME,CENS)~ T+ N,data=breast)
 pllk(as.vector(coef(short)),xmat,ind)
}
