% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.c0.R
\name{pk.calc.c0}
\alias{pk.calc.c0}
\alias{pk.calc.c0.method.logslope}
\alias{pk.calc.c0.method.c0}
\alias{pk.calc.c0.method.c1}
\alias{pk.calc.c0.method.set0}
\alias{pk.calc.c0.method.cmin}
\title{Estimate the concentration at dosing time for an IV bolus dose.}
\usage{
pk.calc.c0(
  conc,
  time,
  time.dose = 0,
  method = c("c0", "logslope", "c1", "cmin", "set0"),
  check = TRUE
)

pk.calc.c0.method.logslope(conc, time, time.dose = 0, check = TRUE)

pk.calc.c0.method.c0(conc, time, time.dose = 0, check = TRUE)

pk.calc.c0.method.c1(conc, time, time.dose = 0, check = TRUE)

pk.calc.c0.method.set0(conc, time, time.dose = 0, check = TRUE)

pk.calc.c0.method.cmin(conc, time, time.dose = 0, check = TRUE)
}
\arguments{
\item{conc}{The observed concentrations}

\item{time}{The observed times}

\item{time.dose}{The time when dosing occurred}

\item{method}{The order of methods to test (see details)}

\item{check}{Check the \code{conc} and \code{time} inputs}
}
\value{
The estimated concentration at time 0.
}
\description{
Estimate the concentration at dosing time for an IV bolus dose.
}
\details{
Methods available for interpolation are below, and each
has its own specific function.

\describe{
  \item{\code{c0}}{If the observed \code{conc} at \code{time.dose} is nonzero, return that.  This method should usually be used first for single-dose IV bolus data in case nominal time zero is measured.}
  \item{\code{logslope}}{Compute the semilog line between the first two measured times, and use that line to extrapolate backward to \code{time.dose}}
  \item{\code{c1}}{Use the first point after \code{time.dose}}
  \item{\code{cmin}}{Set c0 to cmin during the interval.  This method should usually be used for multiple-dose oral data and IV infusion data.}
  \item{\code{set0}}{Set c0 to zero (regardless of any other data).  This method should usually be used first for single-dose oral data.}
}
}
\section{Functions}{
\itemize{
\item \code{pk.calc.c0.method.logslope()}: Semilog regress the first and second points
after time.dose.  This method will return \code{NA} if the second
\code{conc} after \code{time.dose} is 0 or greater than the first.

\item \code{pk.calc.c0.method.c0()}: Use \code{C0} = \code{conc[time %in%
time.dose]} if it is nonzero.

\item \code{pk.calc.c0.method.c1()}: Use \code{C0} = \code{C1}.

\item \code{pk.calc.c0.method.set0()}: Use \code{C0} = 0 (typically used for single
dose oral and IV infusion)

\item \code{pk.calc.c0.method.cmin()}: Use \code{C0} = Cmin (typically used for
multiple dose oral and IV infusion but not IV bolus)

}}
