% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{assert_numeric_between}
\alias{assert_numeric_between}
\title{Confirm that a value is greater than another value}
\usage{
assert_numeric_between(
  x,
  any.missing = FALSE,
  null.ok = FALSE,
  lower_eq = -Inf,
  lower = -Inf,
  upper = Inf,
  upper_eq = Inf,
  ...,
  .var.name = checkmate::vname(x)
)
}
\arguments{
\item{x}{[any]\cr
Object to check.}

\item{any.missing}{[\code{logical(1)}]\cr
Are vectors with missing values allowed? Default is \code{TRUE}.}

\item{null.ok}{[\code{logical(1)}]\cr
If set to \code{TRUE}, \code{x} may also be \code{NULL}.
In this case only a type check of \code{x} is performed, all additional checks are disabled.}

\item{lower_eq, upper_eq}{Values where equality is not allowed}

\item{lower}{[\code{numeric(1)}]\cr
Lower value all elements of \code{x} must be greater than or equal to.}

\item{upper}{[\code{numeric(1)}]\cr
Upper value all elements of \code{x} must be lower than or equal to.}

\item{...}{Passed to \code{checkmate::assert_numeric()}}

\item{.var.name}{[\code{character(1)}]\cr
Name of the checked object to print in assertions. Defaults to
the heuristic implemented in \code{\link[checkmate]{vname}}.}
}
\value{
\code{x}
}
\description{
Confirm that a value is greater than another value
}
