% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.all.R
\name{pk.nca.interval}
\alias{pk.nca.interval}
\title{Compute all PK parameters for a single concentration-time data set}
\usage{
pk.nca.interval(conc, time, interval, options = list())
}
\arguments{
\item{conc}{Concentration measured}

\item{time}{Time of concentration measurement}

\item{interval}{One row of an interval definition (see
\code{\link{check.interval.specification}} for how to define the
interval.}

\item{options}{List of changes to the default
\code{\link{PKNCA.options}} for calculations.}
}
\value{
A data frame with the start and end time along with all PK
parameters for the \code{interval}
}
\description{
For one subject/time range, compute all available PK parameters.
All the internal options should be set by
\code{\link{PKNCA.options}} prior to running.  The only part that
changes with a call to this function is the \code{conc}entration
and \code{time}.
}
\seealso{
\code{\link{check.interval.specification}}
}

