% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pk.calc.urine.R
\name{pk.calc.clr}
\alias{pk.calc.clr}
\title{Calculate renal clearance}
\usage{
pk.calc.clr(ae, auc)
}
\arguments{
\item{ae}{The amount excreted in urine (as a numeric scalar or
vector)}

\item{auc}{The area under the curve (as a numeric scalar or vector)}
}
\value{
The renal clearance as a number
}
\description{
Calculate renal clearance
}
\details{
clr is \code{sum(ae)/auc}.

The units for the \code{ae} and \code{auc} should match such
  that \code{ae/auc} has units of volume/time.
}
\seealso{
\code{\link{pk.calc.ae}}, \code{\link{pk.calc.fe}}
}
