% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/002-pk.business.rules.R
\name{business.mean}
\alias{business.mean}
\alias{business.sd}
\alias{business.cv}
\alias{business.geomean}
\alias{business.geocv}
\alias{business.min}
\alias{business.max}
\alias{business.median}
\alias{business.range}
\title{Generate functions to do the named function (e.g. mean) applying
the business rules.}
\usage{
business.mean(x, ...)

business.sd(x, ...)

business.cv(x, ...)

business.geomean(x, ...)

business.geocv(x, ...)

business.min(x, ...)

business.max(x, ...)

business.median(x, ...)

business.range(x, ...)
}
\arguments{
\item{x}{vector to be passed to the various functions}

\item{...}{Additional arguments to be passed to the underlying
function.}
}
\value{
The value of the various functions or NA if too many values
are missing
}
\description{
Generate functions to do the named function (e.g. mean) applying
the business rules.
}
\section{Functions}{
\itemize{
\item \code{business.sd}: Compute the standard deviation with business rules.

\item \code{business.cv}: Compute the coefficient of variation with business rules.

\item \code{business.geomean}: Compute the geometric mean with business rules.

\item \code{business.geocv}: Compute the geometric coefficient of variation with business rules.

\item \code{business.min}: Compute the minimum with business rules.

\item \code{business.max}: Compute the maximum with business rules.

\item \code{business.median}: Compute the median with business rules.

\item \code{business.range}: Compute the range with business rules.
}}

\seealso{
\code{\link{pk.business}()}
}
