% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/resampling_functions.R
\name{resample_df}
\alias{resample_df}
\title{resampling}
\usage{
resample_df(
  df,
  key_cols,
  strat_cols = NULL,
  n = NULL,
  key_col_name = "KEY",
  replace = TRUE
)
}
\arguments{
\item{df}{data frame}

\item{key_cols}{key columns to resample on}

\item{strat_cols}{columns to maintain proportion for stratification}

\item{n}{number of unique sampled keys, defaults to match dataset}

\item{key_col_name}{name of outputted key column. Default to "KEY"}

\item{replace}{whether to stratify with replacement}
}
\description{
resampling
}
\details{
This function is valuable when generating a large simulated population
where you goal is to create resampled sub-populations in addition to being able to
maintain certain stratifications of factors like covariate distributions

A new keyed column will be created (defaults to name 'KEY') that contains the uniquely
created new samples. This allows one to easily compare against the key'd columns. Eg,
if you would like to see how many times a particular individual was resampled you can 
check the original ID column against the number of key's associated with that ID number.
}
\examples{
library(PKPDmisc)
library(dplyr, quiet = TRUE)

# simple example resampling by ID maintaining Gender distribution, with 10 individuals
resample_df(sd_oral_richpk, key_cols = "ID", strat_cols = "Gender", n = 10)

# for a more complex example lets resample "simulated" data with multiple replicates
subset_data <- sd_oral_richpk \%>\%
   filter(ID < 20)
   
# make 'simulated' data with 5 replicates and combine to single dataframe
rep_dat <- lapply(1:5, function(x) {
subset_data \%>\% 
  mutate(REP = x)
  }) \%>\% bind_rows()

# now when we resample we also want to maintain the ID+REP relationship as resampling
# just the ID would give all rows associated for an ID with all reps, rather than 
# a single "unit" of ID/REP
resample_df(rep_dat, key_cols = c("ID", "REP"))

# check to see that stratification is maintained
rep_dat \%>\% group_by(Gender) \%>\% tally
resample_df(rep_dat, key_cols=c("ID", "REP"), strat_cols="Gender") \%>\%
  group_by(Gender) \%>\% tally
  
rep_dat \%>\% group_by(Gender, Race) \%>\% tally

resample_df(rep_dat, key_cols=c("ID", "REP"), strat_cols=c("Gender", "Race")) \%>\%
  group_by(Gender, Race) \%>\% tally
}
