% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfamily-class.R
\name{PLNPCAfamily}
\alias{PLNPCAfamily}
\title{An R6 Class to represent a collection of PLNPCAfit}
\description{
The function \code{\link[=PLNPCA]{PLNPCA()}} produces an instance of this class.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for \code{\link[=getBestModel]{getBestModel()}},
\code{\link[=getModel]{getModel()}} and \code{\link[=plot.PLNPCAfamily]{plot()}}.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCAs <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
class(myPCAs)
}
\seealso{
The function \code{\link[=PLNPCA]{PLNPCA()}}, the class \code{\link[=PLNPCAfit]{PLNPCAfit()}}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfamily]{PLNmodels::PLNfamily}} -> \code{PLNPCAfamily}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{ranks}}{the dimensions of the successively fitted models}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PLNPCAfamily$new()}}
\item \href{#method-optimize}{\code{PLNPCAfamily$optimize()}}
\item \href{#method-getBestModel}{\code{PLNPCAfamily$getBestModel()}}
\item \href{#method-plot}{\code{PLNPCAfamily$plot()}}
\item \href{#method-show}{\code{PLNPCAfamily$show()}}
\item \href{#method-clone}{\code{PLNPCAfamily$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="getModel">}\href{../../PLNmodels/html/PLNfamily.html#method-getModel}{\code{PLNmodels::PLNfamily$getModel()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="postTreatment">}\href{../../PLNmodels/html/PLNfamily.html#method-postTreatment}{\code{PLNmodels::PLNfamily$postTreatment()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfamily" data-id="print">}\href{../../PLNmodels/html/PLNfamily.html#method-print}{\code{PLNmodels::PLNfamily$print()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
Initialize all models in the collection.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfamily$new(
  ranks,
  responses,
  covariates,
  offsets,
  weights,
  model,
  xlevels,
  control
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ranks}}{the dimensions of the successively fitted models}

\item{\code{responses}}{the matrix of responses common to every models}

\item{\code{covariates}}{the matrix of covariates common to every models}

\item{\code{offsets}}{the matrix of offsets common to every models}

\item{\code{weights}}{the vector of observation weights}

\item{\code{model}}{model used for fitting, extracted from the formula in the upper-level call}

\item{\code{xlevels}}{named listed of factor levels included in the models, extracted from the formula in the upper-level call and used for predictions.}

\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\if{latex}{\out{\hypertarget{method-optimize}{}}}
\subsection{Method \code{optimize()}}{
Call to the C++ optimizer on all models of the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfamily$optimize(control)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{control}}{a list for controlling the optimization. See details.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-getBestModel"></a>}}
\if{latex}{\out{\hypertarget{method-getBestModel}{}}}
\subsection{Method \code{getBestModel()}}{
Extract best model in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfamily$getBestModel(crit = c("BIC", "ICL", "R_squared"))}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{crit}}{a character for the criterion used to performed the selection. Either
"BIC", "ICL", or "R_squared". Default is \code{BIC}}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a \code{\link{PLNPCAfit}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
Lineplot of selected criteria for all models in the collection
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfamily$plot(criteria = c("loglik", "BIC", "ICL"), annotate = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{criteria}}{A valid model selection criteria for the collection of models. Any of "loglik", "BIC" or "ICL" (all).}

\item{\code{annotate}}{Logical. Should R2 be added to the plot (defaults to \code{TRUE})}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{ggplot2}} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\if{latex}{\out{\hypertarget{method-show}{}}}
\subsection{Method \code{show()}}{
User friendly print method
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfamily$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfamily$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
