% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNPCAfit-class.R
\name{PLNPCAfit}
\alias{PLNPCAfit}
\title{An R6 Class to represent a PLNfit in a PCA framework}
\description{
The function \code{\link{PLNPCA}} produces a collection of models which are instances of object with class \code{PLNPCAfit}.

This class comes with a set of methods, some of them being useful for the user:
See the documentation for the methods inherited by  \code{\link[=PLNfit]{PLNfit}} and the
\code{\link[=plot.PLNPCAfit]{plot.PLNPCAfit}} methods for PCA vizualization
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPCAs <- PLNPCA(Abundance ~ 1 + offset(log(Offset)), data = trichoptera, ranks = 1:5)
myPCA <- getBestModel(myPCAs)
class(myPCA)
print(myPCA)
}
\seealso{
The function \code{\link{PLNPCA}}, the class \code{\link[=PLNPCAfamily]{PLNPCAfamily}}
}
\section{Super class}{
\code{\link[PLNmodels:PLNfit]{PLNmodels::PLNfit}} -> \code{PLNPCAfit}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{var_par}}{a list with two matrices, M and S, which are the estimated parameters in the variational approximation}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{loglik}}{variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{criteria}}{a vector with loglik, BIC, ICL, R_squared and number of parameters}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{rank}}{the dimension of the current model}

\item{\code{model_par}}{a list with the matrices associated with the estimated parameters of the pPCA model: Theta (covariates), Sigma (latent covariance) and B (latent loadings)}

\item{\code{var_par}}{a list with two matrices, M and S, which are the estimated parameters in the variational approximation}

\item{\code{latent}}{a matrix: values of the latent vector (Z in the model)}

\item{\code{optim_par}}{a list with parameters useful for monitoring the optimization}

\item{\code{loglik}}{variational lower bound of the loglikelihood}

\item{\code{BIC}}{variational lower bound of the BIC}

\item{\code{ICL}}{variational lower bound of the ICL}

\item{\code{R_squared}}{approximated goodness-of-fit criterion}

\item{\code{criteria}}{a vector with loglik, BIC, ICL, R_squared and number of parameters}

\item{\code{nb_param}}{number of parameters in the current PLN model}

\item{\code{percent_var}}{the percent of variance explained by each axis}

\item{\code{corr_circle}}{a matrix of correlations to plot the correlation circles}

\item{\code{scores}}{a matrix of scores to plot the individual factor maps (a.k.a. principal comonents)}

\item{\code{rotation}}{a matrix of rotation of the latent space}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{PLNPCAfit$new()}}
\item \href{#method-update}{\code{PLNPCAfit$update()}}
\item \href{#method-setVisualization}{\code{PLNPCAfit$setVisualization()}}
\item \href{#method-optimize}{\code{PLNPCAfit$optimize()}}
\item \href{#method-postTreatment}{\code{PLNPCAfit$postTreatment()}}
\item \href{#method-latent_pos}{\code{PLNPCAfit$latent_pos()}}
\item \href{#method-plot_individual_map}{\code{PLNPCAfit$plot_individual_map()}}
\item \href{#method-plot_correlation_circle}{\code{PLNPCAfit$plot_correlation_circle()}}
\item \href{#method-plot_PCA}{\code{PLNPCAfit$plot_PCA()}}
\item \href{#method-compute_fisher}{\code{PLNPCAfit$compute_fisher()}}
\item \href{#method-show}{\code{PLNPCAfit$show()}}
\item \href{#method-clone}{\code{PLNPCAfit$clone()}}
}
}
\if{html}{
\out{<details open ><summary>Inherited methods</summary>}
\itemize{
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="compute_standard_error">}\href{../../PLNmodels/html/PLNfit.html#method-compute_standard_error}{\code{PLNmodels::PLNfit$compute_standard_error()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="predict">}\href{../../PLNmodels/html/PLNfit.html#method-predict}{\code{PLNmodels::PLNfit$predict()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="print">}\href{../../PLNmodels/html/PLNfit.html#method-print}{\code{PLNmodels::PLNfit$print()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="set_R2">}\href{../../PLNmodels/html/PLNfit.html#method-set_R2}{\code{PLNmodels::PLNfit$set_R2()}}\out{</span>}
\item \out{<span class="pkg-link" data-pkg="PLNmodels" data-topic="PLNfit" data-id="VEstep">}\href{../../PLNmodels/html/PLNfit.html#method-VEstep}{\code{PLNmodels::PLNfit$VEstep()}}\out{</span>}
}
\out{</details>}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$new(rank, responses, covariates, offsets, weights, model, control)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-update"></a>}}
\subsection{Method \code{update()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$update(
  Theta = NA,
  Sigma = NA,
  B = NA,
  M = NA,
  S = NA,
  Z = NA,
  A = NA,
  Ji = NA,
  R2 = NA,
  monitoring = NA
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-setVisualization"></a>}}
\subsection{Method \code{setVisualization()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$setVisualization(scale.unit = FALSE)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-optimize"></a>}}
\subsection{Method \code{optimize()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$optimize(responses, covariates, offsets, weights, control)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-postTreatment"></a>}}
\subsection{Method \code{postTreatment()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$postTreatment(responses, covariates, offsets, weights, nullModel)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-latent_pos"></a>}}
\subsection{Method \code{latent_pos()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$latent_pos(covariates, offsets)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_individual_map"></a>}}
\subsection{Method \code{plot_individual_map()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$plot_individual_map(
  axes = 1:min(2, self$rank),
  main = "Individual Factor Map",
  plot = TRUE,
  cols = "default"
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_correlation_circle"></a>}}
\subsection{Method \code{plot_correlation_circle()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$plot_correlation_circle(
  axes = 1:min(2, self$rank),
  main = "Variable Factor Map",
  cols = "default",
  plot = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot_PCA"></a>}}
\subsection{Method \code{plot_PCA()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$plot_PCA(
  nb_axes = min(3, self$rank),
  ind_cols = "ind_cols",
  var_cols = "var_cols",
  plot = TRUE
)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-compute_fisher"></a>}}
\subsection{Method \code{compute_fisher()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$compute_fisher(type = c("wald", "louis"), X = NULL)}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-show"></a>}}
\subsection{Method \code{show()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$show()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{PLNPCAfit$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
