% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PLNmixturefit-S3methods.R
\name{plot.PLNmixturefit}
\alias{plot.PLNmixturefit}
\title{Mixture visualization of a \code{\link{PLNmixturefit}} object}
\usage{
\method{plot}{PLNmixturefit}(x, type = c("pca", "matrix"), main = NULL, plot = TRUE, ...)
}
\arguments{
\item{x}{an R6 object with class \code{\link{PLNmixturefit}}}

\item{type}{character for the type of plot, either "pca", for or "matrix". Default is \code{"pca"}.}

\item{main}{character. A title for the  plot. If NULL (the default), an hopefully appropriate title will be used.}

\item{plot}{logical. Should the plot be displayed or sent back as \code{\link{ggplot}} object}

\item{...}{Not used (S3 compatibility).}
}
\value{
a \code{\link{ggplot}} graphic
}
\description{
Represent the result of the clustering either by coloring the individual in a two-dimension PCA factor map,
or by representing the expected matrix  of count reorder according to the clustering.
}
\examples{
data(trichoptera)
trichoptera <- prepare_data(trichoptera$Abundance, trichoptera$Covariate)
myPLN <- PLNmixture(Abundance ~ 1 + offset(log(Offset)),
           data = trichoptera, control = PLNmixture_param(smoothing = "none"))  \%>\% getBestModel()
\dontrun{
plot(myPLN, "pca")
plot(myPLN, "matrix")
}
}
