% Generated by roxygen2 (4.0.1): do not edit by hand
\name{mod.SPLS}
\alias{mod.SPLS}
\title{Sparse Partial Least Squares (SPLS) algorithm}
\usage{
mod.SPLS(X, Y, A, lambdaY, lambdaX, eps, ...)
}
\arguments{
\item{X}{A (NxP) predictor matrix}

\item{Y}{A (NxM) response matrix}

\item{A}{The number of PLS components}

\item{lambdaY}{A value for the penalty parameters for the soft-thresholding penalization function for Y-weights}

\item{lambdaX}{A value for the penalty parameters for the soft-thresholding penalization function for X-weights}

\item{eps}{Cut off value for convergence step}

\item{...}{Other arguments. Currently ignored}
}
\value{
The SPLS parameters of D=[X Y]
}
\description{
Takes in a set of predictor variables and a set of response variables and gives the SPLS parameters.
}
\examples{
if(require(chemometrics))
data(ash, package="chemometrics")
X1 = as.matrix(ash[,10:17], ncol=8)
Y1 = as.matrix(ash$SOT)
colnames(Y1) = paste("SOT")
mod.SPLS(X=scale(X1), Y=scale(Y1), A=2, lambdaY=0, lambdaX=10.10, eps=1e-5)
#lambdaX and lambdaY value are determined using function opt.penalty.values
#for more details, see opt.penalty.values help file
}
\author{
Opeoluwa F. Oyedele and Sugnet Gardner-Lubbe
}

