% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PMA-package.R
\docType{package}
\name{PMA-package}
\alias{PMA-package}
\alias{PMA}
\title{Penalized Multivariate Analysis}
\description{
This package is called \strong{PMA}, for __P__enalized __M__ultivariate
__A__nalysis.  It implements three methods: A penalized matrix
decomposition, sparse principal components analysis, and sparse
canonical correlations analysis. All are described in the reference below.
The main functions are: \code{PMD}, \code{CCA} and \code{SPC}.
}
\details{
The first, \code{PMD}, performs a penalized matrix decomposition.  \code{CCA}
performs sparse canonical correlation analysis. \code{SPC} performs sparse
principal components analysis.

There also are cross-validation functions for tuning parameter selection for
each of the above methods: \code{SPC.cv}, \code{PMD.cv}, \code{CCA.permute}. And \code{PlotCGH} produces
nice plots for DNA copy number data.
}
\references{
Witten D. M., Tibshirani R.,  and Hastie, T. (2009) \doi{10.1093/biostatistics/kxp008}.
}
\keyword{package}
