% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pageTest.R
\name{pageTest}
\alias{pageTest}
\alias{pageTest.default}
\title{Page Rank Sum Test}
\usage{
pageTest(y, ...)

\method{pageTest}{default}(
  y,
  groups,
  blocks,
  alternative = c("two.sided", "greater", "less"),
  ...
)
}
\arguments{
\item{y}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{groups}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}. Ignored with a warning if \code{"x"} is a list.}

\item{blocks}{a vector or factor object giving the block for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis.
Defaults to \code{two.sided}.}

\item{\ldots}{further arguments to be passed to or from methods.}
}
\value{
A list with class \code{"htest"} containing the following components:
\describe{
 \item{method}{a character string indicating what type of test was performed.}
 \item{data.name}{a character string giving the name(s) of the data.}
 \item{statistic}{the estimated quantile of the test statistic.}
 \item{p.value}{the p-value for the test.}
 \item{parameter}{the parameters of the test statistic, if any.}
 \item{alternative}{a character string describing the alternative hypothesis.}
\item{estimates}{the estimates, if any.}
\item{null.value}{the estimate under the null hypothesis, if any.}
}
}
\description{
Performs Page's ordered aligned rank sum test.
}
\examples{
## Sachs (1997), pp. 671 ff.
## 9 reviewers (blocks)
## assigned ranks to 4 objects (groups).
data(reviewers)
## See Sachs (1997) p. 677
pageTest(reviewers, alternative = "greater")

}
\references{
Page, E. B. (1963) Ordered hypotheses for multiple treatments: A
significance test for linear ranks, \emph{Journal of the
American Statistical Association} \bold{58}, 216--230.

Sachs, L. (1997) \emph{Angewandte Statistik}. Berlin: Springer.
}
\seealso{
\code{\link{friedmanTest}}
}
\keyword{htest}
\keyword{nonparametric}
