% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chenTest.R
\name{chenTest}
\alias{chenTest}
\alias{chenTest.default}
\alias{chenTest.formula}
\title{Chen's Many-to-One Comparisons Test}
\usage{
chenTest(x, ...)

\method{chenTest}{default}(
  x,
  g,
  alternative = c("greater", "less"),
  p.adjust.method = p.adjust.methods,
  ...
)

\method{chenTest}{formula}(
  formula,
  data,
  subset,
  na.action,
  alternative = c("greater", "less"),
  p.adjust.method = p.adjust.methods,
  ...
)
}
\arguments{
\item{x}{a numeric vector of data values, or a list of numeric data
vectors.}

\item{\dots}{further arguments to be passed to or from methods.}

\item{g}{a vector or factor object giving the group for the
corresponding elements of \code{"x"}.
Ignored with a warning if \code{"x"} is a list.}

\item{alternative}{the alternative hypothesis. Defaults to \code{two.sided}.}

\item{p.adjust.method}{method for adjusting p values
(see \code{\link{p.adjust}})}

\item{formula}{a formula of the form \code{response ~ group} where
\code{response} gives the data values and \code{group} a vector or
factor of the corresponding groups.}

\item{data}{an optional matrix or data frame (or similar: see
\code{\link{model.frame}}) containing the variables in the
formula \code{formula}.  By default the variables are taken from
\code{environment(formula)}.}

\item{subset}{an optional vector specifying a
subset of observations to be used.}

\item{na.action}{a function which indicates what should happen when
the data contain \code{NA}s.  Defaults to \code{getOption("na.action")}.}
}
\value{
A list with class \code{"PMCMR"} containing the following components:
\describe{
\item{method}{a character string indicating what type of test was performed.}
\item{data.name}{a character string giving the name(s) of the data.}
\item{statistic}{lower-triangle matrix of the estimated
quantiles of the pairwise test statistics.}
\item{p.value}{lower-triangle matrix of the p-values for the pairwise tests.}
\item{alternative}{a character string describing the alternative hypothesis.}
\item{p.adjust.method}{a character string describing the method for p-value
adjustment.}
\item{model}{a data frame of the input data.}
\item{dist}{a string that denotes the test distribution.}
}
}
\description{
Performs Chen's nonparametric test for contrasting increasing
(decreasing) dose levels of a treatment.
}
\details{
Chen's test is a non-parametric step-down trend test for
testing several treatment levels with a zero control.
Let \eqn{X_{0j}} denote a variable with the \eqn{j}-th
realization of the control group (\eqn{1 \le j \le n_0})
and \eqn{X_{ij}} the \eqn{j}-the realization
in the \eqn{i}-th treatment group (\eqn{1 \le i \le k}).
The variables are i.i.d. of a least ordinal scale with
\eqn{F(x) = F(x_0) = F(x_i), ~ (1 \le i \le k)}.
A total of \eqn{m = k} hypotheses can be tested:

\deqn{
\begin{array}{ll}
\mathrm{H}_{m}: \theta_0 = \theta_1 = \ldots = \theta_m, & \mathrm{A}_{m} = \theta_0 \le \theta_1 \le \ldots \theta_m, \theta_0 < \theta_m \\
\mathrm{H}_{m-1}: \theta_0 = \theta_1 = \ldots = \theta_{m-1}, & \mathrm{A}_{m-1} = \theta_0 \le \theta_1 \le \ldots \theta_{m-1}, \theta_0 < \theta_{m-1} \\
\vdots & \vdots \\
\mathrm{H}_{1}: \theta_0 = \theta_1, & \mathrm{A}_{1} = \theta_0 < \theta_1\\
\end{array}
}

The statistics \eqn{T_i} are based on a Wilcoxon-type ranking:

\deqn{
T_i = \sum_{j=0}^{i=1} \sum_{u=1}^{n_i} \sum_{v=1}^{n_j} I(x_{iu} - x_{jv}), \qquad (1 \leq i \leq k),
}

where the indicator function returns \eqn{I(a) = 1, ~ \mathrm{if}~ a > 0, 0.5 ~ \mathrm{if} a = 0}
otherwise \eqn{0}.

The expected \eqn{i}th mean is
\deqn{
\mu(T_i) = n_i N_{i-1} / 2,
}

with \eqn{N_j = \sum_{j =0}^i n_j} and the \eqn{i}th variance:

\deqn{
\sigma^2(T_i) = n_i N_{i-1} / 12 ~ \left\{N_i + 1 -
\sum_{j=1}^g t_j \left(t_j^2 - 1 \right) /
\left[N_i \left( N_i - 1 \right)\right]\right\}.
}

The test statistic \eqn{T_i^*} is asymptotically standard normal

\deqn{
 T_i^* = \frac{T_i - \mu(T_i)}
 {\sqrt{\sigma^2(T_i)}}, \qquad (1 \leq i \leq k).
}

The p-values are calculated from the standard normal distribution.
The p-values can be adjusted with any method as available
by \code{\link{p.adjust}}.
}
\examples{
## Chen, 1999, p. 1237,
## Minimum effective dose (MED)
## is at 2nd dose level
df <- data.frame(x = c(23, 22, 14,
27, 23, 21,
28, 37, 35,
41, 37, 43,
28, 21, 30,
16, 19, 13),
g = gl(6, 3))
levels(df$g) <- 0:5
ans <- chenTest(x ~ g, data = df, alternative = "greater",
                p.adjust.method = "holm")
summary(ans)

}
\references{
Chen, Y.-I., 1999, Nonparametric Identification of the
Minimum Effective Dose. \emph{Biometrics} \strong{55}, 1236--1240.
\doi{10.1111/j.0006-341X.1999.01236.x}
}
\seealso{
\code{\link{wilcox.test}}, \code{\link{Normal}}
}
\concept{wilcoxonranks}
\keyword{htest}
\keyword{nonparametric}
