\name{Generation of counts from a non-linear Smooth Transition Poisson NAR(p) model}
\alias{poisson.MODpq.stnar}

\title{
Generation of counts from a non-linear Smooth Transition Poisson NAR(p)
model with q covariates (ST-PNAR(p))
}

\description{
Generation of counts from a non-linear Smooth Transition Poisson Network
Autoregressive model of order \eqn{p} with \eqn{q} covariates (ST-PNAR(\eqn{p})).
}

\usage{
poisson.MODpq.stnar(b, W, gama, a, p, d, Z = NULL, TT, N,
copula = "gaussian", corrtype = "equicorrelation", rho, dof = 1)
}

\arguments{
\item{b}{
The linear coefficients of the model, in the following order: (intercept, network
parameters, autoregressive parameters, covariates). The dimension of the vector
should be 2\code{p} + 1 + number of covariates.
}
\item{W}{
The \code{N} x \code{N} row-normalized non-negative adjacency matrix describing
the network. The main diagonal entries of the matrix should be zeros, all the
other entries should be non-negative and the maximum sum of elements over the
rows should equal one. The function row-normalizes the matrix if a non-normalized
adjacency matrix is provided.
}
\item{gama}{
The scalar nuisance smoothing parameter.
}
\item{a}{
Vector of non-linear parameters. The dimension of the vector should be \code{p}.
}
\item{p}{
The number of lags in the model.
}
\item{d}{
The lag parameter of non-linear variable (should be between 1 and p).
}
\item{Z}{
An \code{N} x \eqn{q} matrix of covariates (one for each column),
where \eqn{q} is the number of covariates in the model.
Note that they must be non-negative.
}
\item{TT}{
The temporal sample size.
}
\item{N}{
The number of nodes on the network.
}
\item{copula}{
Which copula function to use? The "gaussian", "t", or "clayton"?
}
\item{rho}{
The value of the copula parameter (\eqn{\rho}). A scalar in \eqn{[-1,1]} for
elliptical copulas (Gaussian, t), a value greater than or equal to -1 for Clayton
copula.
}
\item{corrtype}{
Used only for elliptical copulas. The type of correlation matrix employed for
the copula; it will either be the "equicorrelation" or "toeplitz". The
"equicorrelation" option generates a correlation matrix where all the off-diagonal
entries equal \eqn{\rho}. The "toeplitz" option generates a correlation matrix
whose generic off-diagonal \eqn{(i,j)}-element is \eqn{\rho^{|i-j|}}.
}
\item{dof}{
The degrees of freedom for Student's t copula.
}
}

\details{
This function generates counts from a non-linear Smooth Transition Poisson NAR(\eqn{p}) model, where
\eqn{q} non time-varying covariates are allowed as well. The counts are simulated from \eqn{Y_{t}=N_{t}(\lambda_{t})},
where \eqn{N_{t}} is a sequence of \code{N}-dimensional IID Poisson count processes, with intensity 1, and whose structure of dependence is modelled through a copula construction \eqn{C(\rho)} on their associated exponential waiting times random variables. For details see Armillotta and Fokianos (2022a, Sec. 2.1-2.2).

The sequence \eqn{\lambda_{t}} is the expecation of \eqn{Y_{t}} conditional to its past values and it is generated by
means of the following ST-PNAR(\eqn{p}) model. For each node of the network \eqn{i=1,...,N} over the time sample \eqn{t=1,...,TT}
\deqn{
\lambda_{i,t}=\beta_{0}+\sum_{h=1}^{p}\beta_{1h}X_{i,t-h}+\beta_{2h}Y_{i,t-h}+\alpha_{h}e^{-\gamma X_{i,t-d}^{2}}X_{i,t-h}+\sum_{l=1}^{q}\delta_{l}Z_{i,l}
}
where \eqn{X_{i,t}=\sum_{j=1}^{N}W_{ij}Y_{j,t}} is the network effect, i.e. the weighted average impact of node \eqn{i}
connections, with the weights of the mean being \eqn{W_{ij}}, the single element of the network matrix \eqn{W}.

The parameter \eqn{\beta_{0}} is the intercept of the model, \eqn{\beta_{1h}} are the network coefficients, \eqn{\beta_{2h}} are the autoregressive parameters, \eqn{\alpha_{h}} are the non-linear smooth transition parameters, \eqn{\gamma} is the nuisance smoothing parameter, and \eqn{\delta_{l}} are the coefficients assocciated to the covariates \eqn{Z_{i,l}}. The coefficient \eqn{d} is considered as an extra parameter defining the lag of the network effect in the non-linear part of the model and is left to be set by the user. For details on ST-PNAR models see Armillotta and Fokianos (2022b, Sec. 2).
}

\value{
A list including:
\item{p2R}{
The Toeplitz correlation matrix, if employed in the copula or NULL else.
}
\item{lambda}{
An \code{N} x \code{TT} matrix of generated Poisson means for \code{N} time
series over \code{TT}.
}
\item{y}{
An \code{N} x \code{TT} matrix of generated counts for \code{N} time series
over \code{TT}.
}
}

\seealso{
\code{\link{poisson.MODpq}, \link{poisson.MODpq.log},
\link{poisson.MODpq.nonlin}, \link{poisson.MODpq.tnar}
}
}

\references{
Armillotta, M. and K. Fokianos (2022a). Poisson network autoregression.
\url{https://arxiv.org/abs/2104.06296}

Armillotta, M. and K. Fokianos (2022b). Testing linearity for network
autoregressive models.
\url{https://arxiv.org/abs/2202.03852}
}

\author{
Mirko Armillotta, Michail Tsagris and Konstantinos Fokianos.
}

\examples{
W <- adja( N = 20, K = 5, alpha= 0.5)
y <- poisson.MODpq.stnar( b = c(0.5, 0.3, 0.2), W = W, gama = 0.2, a = 0.4,
p = 1, d = 1, Z = NULL, TT = 1000, N = 20, copula = "gaussian",
corrtype = "equicorrelation", rho = 0.5)$y
}
