% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.POST.R
\name{print}
\alias{print}
\alias{print.POST}
\title{Print the Primary Results of a post() Analysis}
\usage{
\method{print}{POST}(x, ..., siglevel = 1)
}
\arguments{
\item{x}{A POST object. The value object returned by a call to post()}

\item{...}{Further arguments passed to or from other methods}

\item{siglevel}{A numeric object. If < 1, shows only the OTUs for which
the p-value is below the specified siglevel.}
}
\value{
No return value, called to display key results.
}
\description{
Print the primary results of a post() analysis.
}
\examples{

data("POSTmData")

y <- as.integer(x = metadata[,"GC"] == "BV")
X <- metadata[,"mRace"]

result <- post(y = y, 
               X = X, 
               OTU = otu[,1:20], 
               tree = otutree,
               cValues = seq(0,0.05,by=0.01))

print(x = result)

}
