% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poset_from_incidence.R
\name{poset_from_incidence}
\alias{poset_from_incidence}
\title{Generates a Partially Ordered SET from an incidence matrix}
\usage{
poset_from_incidence(x)
}
\arguments{
\item{x}{a \code{logical} matrix.}
}
\value{
an environment of class \code{poset}.
}
\description{
This function generates a poset from an incidence matrix \code{x}. Such matrix is a named and \code{logical} that is \code{TRUE} if the row element is dominated by the column one, \code{FALSE} otherwise. Such incidence relation should be reflexive, anti-symmetric, and transitive..
}
\examples{
x <- c(
  TRUE, FALSE, FALSE, FALSE, FALSE, FALSE,
  TRUE,  TRUE, FALSE, FALSE, FALSE, FALSE,
  TRUE,  TRUE,  TRUE, FALSE, FALSE, FALSE,
  TRUE, FALSE, FALSE,  TRUE, FALSE, FALSE,
  TRUE,  TRUE, FALSE,  TRUE,  TRUE, FALSE,
  TRUE,  TRUE,  TRUE,  TRUE,  TRUE,  TRUE
)
x <- matrix(x, nrow = 6, ncol = 6)
rownames(x) <- colnames(x) <- LETTERS[1:6]
p <- poset_from_incidence(x)
plot(p)
}
\references{
\insertRef{davey2002introduction}{POSetR}
}
\seealso{
\code{\link[POSetR]{poset}}.
}
