% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{PMR_summary}
\alias{PMR_summary}
\title{PMR model with summary data}
\usage{
PMR_summary(betaxin, betayin, Sigma1sin, Sigma2sin, samplen1, samplen2,
  gammain, alphain, max_iterin, epsin)
}
\arguments{
\item{betaxin}{the cis-SNP effect size vector for one specific gene in eQTL 
data, which must be calculated based on both the standardized gene expression 
value and the standardized cis-genotype matrix.}

\item{betayin}{the cis-SNP effect size vector for one specific gene in GWAS 
data, which be calculated based on both the standardized complex trait value 
and the standardized cis-genotype matrix.}

\item{Sigma1sin}{the LD matrix in eQTL data.}

\item{Sigma2sin}{the LD matrix in GWAS data. Both \code{Sigma2sin} and 
\code{sigma1sin} are often the same from the reference panel.}

\item{samplen1}{the sample size of eQTL data.}

\item{samplen2}{the sample size of GWAS data.}

\item{gammain}{indicator variable for constrained model, with 1 for the null 
model that there is no horizontal pleiotropy.}

\item{alphain}{indicator variable for constrained model, with 1 for the null 
model that there is no causal effect.}

\item{max_iterin}{The maximum iteration.}

\item{epsin}{The convergence tolerance of the absolute value of the difference 
between the nth and (n+1)th log likelihood.}
}
\value{
A list of estimates of model parameters, including the causal effect 
\code{alpha}, the horizontal pleiotropy effect \code{gamma}, and the two corresponding p values.
}
\description{
Fit the probabilistic MR model with summary data while accounting for the 
correlated instruments and horizontal pleiotropy in TWAS framework.
}
\examples{
data(Examplesummary)
attach(Examplesummary)
fmH1=PMR_summary(betaxin=betax,betayin=betay,Sigma1sin=Sigma1,Sigma2sin=Sigma2,
      samplen1=n1,samplen2=n2,gammain=0,alphain=0,max_iterin =1000, epsin=1e-5)
fmH0alpha=PMR_summary(betaxin=betax,betayin=betay,Sigma1sin=Sigma1,Sigma2sin=Sigma2,
           samplen1=n1,samplen2=n2,gammain=0,alphain=1,max_iterin =1000, epsin=1e-5)
fmH0gamma=PMR_summary(betaxin=betax,betayin=betay,Sigma1sin=Sigma1,Sigma2sin=Sigma2,
           samplen1=n1,samplen2=n2,gammain=1,alphain=0,max_iterin =1000, epsin=1e-5)
loglikH1=max(fmH1$loglik,na.rm=TRUE)
loglikH0alpha=max(fmH0alpha$loglik,na.rm=TRUE)
loglikH0gamma=max(fmH0gamma$loglik,na.rm=TRUE)
stat_alpha = 2 * (loglikH1 - loglikH0alpha)
pvalue_alpha = pchisq(stat_alpha,1,lower.tail=FALSE)
stat_gamma = 2 * (loglikH1 - loglikH0gamma)
pvalue_gamma = pchisq(stat_gamma,1,lower.tail=FALSE)

}
\author{
Zhongshang Yuan, Xiang Zhou.
}
