% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prisma.r
\name{prisma}
\alias{prisma}
\title{Generate a PRISMA statement flow chart}
\source{
\url{http://prisma-statement.org/PRISMAStatement/FlowDiagram}
}
\usage{
prisma(found, found_other, no_dupes, screened, screen_exclusions,
  full_text, full_text_exclusions, qualitative, quantitative,
  labels = NULL, extra_dupes_box = FALSE, ..., dpi = 72)
}
\arguments{
\item{found}{Records found through database searching}

\item{found_other}{Additional records identified through other sources}

\item{no_dupes}{Records after duplicates removed}

\item{screened}{Records screened}

\item{screen_exclusions}{Records excluded}

\item{full_text}{Full-text articles assessed for eligibility}

\item{full_text_exclusions}{Full-text articles excluded with reasons}

\item{qualitative}{Studies included in qualitative analysis}

\item{quantitative}{Studies included in quantitative synthesis
(meta-analysis)}

\item{labels}{\code{NULL} is the default, but if a named list of character
strings, the box matching each name will get the corresponding label. See
examples.}

\item{extra_dupes_box}{Single logical value, default is \code{FALSE} which
corresponds to the example 2009 PRISMA Statement Flow Chart. If
\code{TRUE}, then an additional box will be presented indicating the number
of duplicates removed, calculated from the other numbers.}

\item{...}{Further arguments are passed to \code{grViz}}

\item{dpi}{Dots per inch, 72 is the default here, and in \code{DiagrammeR}
itself it claims to be 96. Varying the DPI (which is done in the DOT file)
unfortunately does not get detected by the downstream processing by the
'htmlwidgets' package. To overcome this, the user can add `height` and
`width` arguments which are passed through. It is easy to for scaled graphs
to fall off the canvas, or be crushed into the top-left corner, and
unfortunately this requires trial and error. Increasing DPI over 72 with
this setting tends to truncate the graph. On the other hand, leaving the
DPI at 72 and increasing both height and width appears to consistently give
higher resolution images.}
}
\description{
Generate PRISMA statement flow chart for use in retrospective medical
research. Almost all arguments are mandatory, as they are in the recommended
PRISMA statement.
}
\examples{
prisma(1000, 20, 270, 270, 10, 260, 20, 240, 107)
prisma(1000, 20, 270, 270, 10, 260, 20, 240, 107,
       labels = list(found = "FOUND"))
prisma(1000, 20, 270, 270, 10, 260, 20, 240, 107, dpi = 24)
prisma(1000, 20, 270, 270, 10, 260, 20, 240, 107, extra_dupes_box = TRUE)
# giving impossible numbers should cause an error
tryCatch(
  prisma(1, 2, 3, 4, 5, 6, 7, 8, 9),
  error = function(e) e$message)
# giving unlikely numbers should cause a warning
tryCatch(
  prisma(1000, 20, 270, 270, 10, 260, 19, 240, 107),
  warning = function(w) w$message)
tryCatch(
  prisma(1000, 20, 270, 270, 269, 260, 20, 240, 107),
  warning = function(w) w$message)
}
