% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pop_step.R
\name{pop_step}
\alias{pop_step}
\title{Surviving a non-selective process}
\usage{
pop_step(start, start_comb = NA, result = NA, stepname = NA,
  surv_prob, max_vec_length = 1e+07)
}
\arguments{
\item{start}{column names of parental cohorts. \code{character vector}.}

\item{start_comb}{all named columns in \code{start} are joined and returned as a column with the name of \code{start_comb} (\code{character}). Only used when \code{start} longer than 1.}

\item{result}{name of the results column. \code{character}.}

\item{stepname}{name of the new column of dfgenotype added by this function. \code{character}.}

\item{surv_prob}{probability to survive this step and reach the next growth stage. \code{numeric}.}

\item{max_vec_length}{used internally, a technical term, defining the maximum length of vectors to be used.}
}
\value{
A new column is added to \code{dfgenotype} containing the surviving individuals of the different genotypes.
}
\description{
\code{pop_step} picks the individuals that will pass to the next development stage. This is a random process for every individual, which does not exert any selection pressure.
}
\details{
Individuals that reach the next growth stage are picked by using \code{\link{rbinom}}. In contrast to \code{\link{sel_herb}}, \code{pop_step} does not exert any evolutionary selection pressure.
When more than one column is selected with \code{start}, they are summed and the result is passed to the picking process. By setting \code{start_comb} the sum is added as a column to \code{dfgenotype}.
}
\examples{
struc_preparation(Rmx=10, n_loci=2, epis=0, dom=1)
gen_freq(af=c(0.01,0.8), n_seeds=10000)
#How many individuals of each genotype will reach the next growth stage?
pop_step(start="initialSB",  stepname="survivingthewinter",
                            surv_prob=0.4)
}
\seealso{
\code{\link{quanti}} \code{\link{pop_germc}}
}
