% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rerange.R
\name{rerange}
\alias{rerange}
\alias{rerange100}
\title{Change the range of an item or score}
\usage{
rerange(score, old = NULL, new = c(0, 100), rev = FALSE)

rerange100(score, mn, mx)
}
\arguments{
\item{score}{The variable to be re-ranged.}

\item{old}{A numeric vector of length 2 indicating the old range (e.g.,
\code{c(min, max)} \code{score}.  This is a required argument.}

\item{new}{A numeric vector of length 2 indicating the new range you want for
\code{score}.  The default value is \code{c(0, 100)}.}

\item{rev}{Logical, if \code{TRUE} \code{score} will will not only be
re-ranged, but it will also be reversed (see Details for more information).
The default is \code{FALSE}.}

\item{mn}{The minimum possible value that \code{score} can take.}

\item{mx}{The maximum possible value that \code{score} can take.}
}
\value{
A re-ranged vector.

A version of \code{score} that is rescaled to range from 0 to 100.
}
\description{
\itemize{
\item \code{rerange} linearly rescales a numeric variable to have new
minimum and maximum values of the user's choosing.
\item \code{rerange100} is a simplified version of \code{rerange} that
rescales a variable to range from 0 to 100.
}
}
\details{
The \code{rerange} function can re-range and reverse code a variable
all at once. If \code{rev = TRUE}, \code{score} will be reversed using
\code{\link{revcode}} after it is re-ranged.  The same could be
accomplished by keeping \code{rev = FALSE} and reversing the order of the
range given to \code{new}.  For example, the following two calls to
\code{rerange} will return the same values:
\itemize{
\item \code{rerange(score, old = c(0, 10), new = c(0, 100), rev = TRUE)}
\item \code{rerange(score, old = c(0, 10), new = c(100, 0), rev = FALSE)}
}

The \code{rerange100} function is a short-cut for \code{rerange} with the
arguments set to the values typically used when scoring a PRO measure.
Specifically, \code{rerange100} is defined as:
\itemize{
\item \code{rerange(score, old = c(mn, mx), new = c(0, 100), rev = FALSE)}
}

These functions can produce verbose warning messages.  If you are using this
function within another function, you can suppress these messages by
wrapping your call to \code{rerange} in \code{suppressWarnings()}.
}
\examples{
qol_score <- c(0:4)

# Default is to rerange to c(0, 100)
rerange(qol_score, old = c(0, 4))
# Below gives same result as above
rerange100(qol_score, 0, 4)

# These two lines are different ways to rerange and reverse code at same time
rerange(qol_score, old = c(0, 4), new = c(0, 100), rev = TRUE)
rerange(qol_score, old = c(0, 4), new = c(100, 0))
}
