% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\docType{methods}
\name{plot,PROsetta_data,ANY-method}
\alias{plot,PROsetta_data,ANY-method}
\title{Plot frequency distribution}
\usage{
\S4method{plot}{PROsetta_data,ANY}(
  x,
  y,
  scale_id = "combined",
  filename = NULL,
  title = NULL,
  xlim = NULL,
  color = "blue",
  nbar = 20,
  rug = FALSE,
  filetype = "pdf",
  savefile = FALSE,
  bg = "white",
  width = 6,
  height = 6,
  pointsize = 12
)
}
\arguments{
\item{x}{a \code{\linkS4class{PROsetta_data}} object.}

\item{y}{unused argument, exists for compatibility with \code{\link{plot}} in the base R package.}

\item{scale_id}{scale ID to plot. \code{combined} (default) represents the combined scale.}

\item{filename}{filename to write if '\code{savefile}' argument is \code{TRUE}.}

\item{title}{the title of the figure.}

\item{xlim}{the range of scores to plot.}

\item{color}{the color to fill the histogram.}

\item{nbar}{the number of histogram bars.}

\item{rug}{if \code{TRUE}, display the actual distribution of scores below each bar.}

\item{filetype}{the type of file to write if '\code{savefile}' argument is \code{TRUE}. Accepts '\code{pdf}', '\code{jpeg}', '\code{png}', and '\code{tiff}'.}

\item{savefile}{if \code{TRUE}, save the figure as a file.}

\item{bg}{the background color of the plot.}

\item{width}{the width of the plot.}

\item{height}{the height of the plot.}

\item{pointsize}{point size to pass onto file writing functions.}
}
\description{
This is an extension of \code{\link{plot}} to visualize frequency distribution from \code{\linkS4class{PROsetta_data}} object.
}
\examples{
plot(data_asq)
plot(data_asq, scale_id = 1)
plot(data_asq, scale_id = 2)

}
