% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DP_PSSM.R
\name{DP_PSSM}
\alias{DP_PSSM}
\title{DP_PSSM feature vector}
\usage{
DP_PSSM(pssm_name, a = 2)
}
\arguments{
\item{pssm_name}{name of PSSM matrix file}

\item{a}{fixed parameter that user chooses which usually equals to 2}
}
\value{
feature vector of length 120
}
\description{
This feature results from the connection of two vectors. The vector is the first feature of a
vector with a length of 40, which calculates the average of positive and negative values for each column
separately and puts them together. in the second feature vector, correspond to each column the difference
between the numbers in the rows that have distance of k is calculated, and then the square average for the
differences that are positive is calculated, and the same action  for the differences that are negative is
performed. since k varies between 1 and \eqn{\alpha}, and because the value of \eqn{\alpha} in this function is equal to 2,
the length of the second feature vector will be 80, which by merging with the first feature vector, the total
feature vector of length 120 will be obtained.
}
\examples{
ss<-DP_PSSM(system.file("extdata", "C7GQS7.txt.pssm", package="PSSMCOOL"))
}
\references{
Juan, E.Y., et al. (2009) Predicting Protein Subcellular Localizations for Gram-Negative Bacteria using DP-PSSM
and Support Vector Machines. Complex, Intelligent and Software Intensive Systems, 2009. CISIS'09. International
Conference on. IEEE, pp. 836-841.
}
