% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_plots.R
\name{getHTMLTable}
\alias{getHTMLTable}
\title{Create an HTML table with an extra header row}
\usage{
getHTMLTable(data, header = NA, font_size = 12)
}
\arguments{
\item{data}{A data.frame which serves as table}

\item{header}{A set of headlines, e.g. c("top line", "bottom line")}

\item{font_size}{Html font size}
}
\value{
table as character string for cat()'ing into html
}
\description{
Create an HTML table with an extra header row
}
\examples{
  data = data.frame(raw.file = letters[1:4],
                    id.rate = 3:6)
  getHTMLTable(data, 
               header = "some header line", 
               font_size = 11)

}

