% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fcn_QCHeat.R
\name{getQCHeatMap}
\alias{getQCHeatMap}
\title{Generate a Heatmap from a list of QC measurements.}
\usage{
getQCHeatMap(lst_qcMetrics, raw_file_mapping)
}
\arguments{
\item{lst_qcMetrics}{List of QCMetric objects}

\item{raw_file_mapping}{Data.frame with 'from' and 'to' columns for name mapping to unify names from list entries}
}
\value{
A ggplot object for printing
}
\description{
Each list entry is a data.frame with two columns. 
The first one contains the Raw file name (or the short version).
and should be named 'raw.file' (or 'fc.raw.file'). 
The second column's name must be an expression (see ?plotmath)
and contains quality values in the range [0,1]. If values are outside this range, 
a warning is issued and values are cut to the nearest allowed value (e.g. '1.2' becomes '1').
List entries are merged and columns are ordered by name.
  
All substrings enclosed by 'X[0-9]*X.' will be removed (can be used for sorting columns).
The resulting string is evaluated as an expression. 
E.g. parse(text = <colname>)
}
\details{
To judge the overall quality of each raw file a summary column is added, 
values being the mean of all other columns per row.
}
