% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freundlich.r
\name{freundlichanalysis}
\alias{freundlichanalysis}
\title{Freundlich Isotherm Analysis Non-Linear Form}
\usage{
freundlichanalysis(Ce, Qe)
}
\arguments{
\item{Ce}{the numerical value for the equilibrium capacity}

\item{Qe}{the numerical value for the adsorbed capacity}
}
\value{
the nonlinear regression and the parameters for the Freundlich isotherm
}
\description{
This isotherm model is an empirical model applicable to diluted solutions adsorption processes (Gessner and Hasan, 1987). Furthermore, this model gives an equation which defines the surface heterogeneity and the exponential distribution of active sites (Ayawei, et al., 2017).
}
\examples{
 Ce <- c(0.01353, 0.04648, 0.13239, 0.27714, 0.41600, 0.63607, 0.80435, 1.10327, 1.58223)
 Qe <- c(0.03409, 0.06025, 0.10622, 0.12842, 0.15299, 0.15379, 0.15735, 0.15735, 0.16607)
}
\references{
Ayawei, N., Ebelegi, A. N., & Wankasi, D. (2017). Modelling and Interpretation of Adsorption Isotherms. Journal of Chemistry, 2017, 1–11. doi: 10.1155/2017/3039817

Gessner, P. K., & Hasan, M. M. (1987). Freundlich and Langmuir Isotherms as Models for the Adsorption of Toxicants on Activated Charcoal. Journal of Pharmaceutical Sciences, 76(4), 319–327. doi: 10.1002/jps.2600760412
}
\author{
Carl Luis P. Flestado

C.C. Deocaris
}
