% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/monitor_replaceData.R
\name{monitor_replaceData}
\alias{monitor_replaceData}
\title{Subset Monitoring Data}
\usage{
monitor_replaceData(ws_monitor, filter, value)
}
\arguments{
\item{ws_monitor}{\emph{ws_monitor} object}

\item{filter}{an \R{R} expression used to identify values for replacement}

\item{value}{replacement value}
}
\description{
Use an R expression to identify values for replacement.

The \R{R} expression given in \code{filter} is used to identify elements
in \code{ws_monitor$data} that should be replaced.  Typical usage would include
\enumerate{
\item{replacing negative values with 0}
\item{replacing unreasonably high values with \code{NA}}
}

Expressions should use \code{data} for the left hand side of the comparison.
}
\examples{
wa <- monitor_subset(Northwest_Megafires, stateCodes='WA')
wa_zero <- monitor_replaceData(wa, data < 0, 0)
}
\keyword{ws_monitor}
