% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airnow_downloadData.R
\name{airnow_downloadData}
\alias{airnow_downloadData}
\title{Download and Aggregate Multiple Hourly Data Files from AirNow}
\usage{
airnow_downloadData(parameters = NULL, startdate = "", hours = 24)
}
\arguments{
\item{parameters}{vector of names of desired pollutants or NULL for all pollutants}

\item{startdate}{desired start date (integer or character representing YYYYMMDD[HH])}

\item{hours}{desired number of hours of data to assemble}
}
\value{
Dataframe of aggregated AirNow data.
}
\description{
This function makes repeated calls to \link{airnow_downloadHourlyData}
to obtain data from AirNow. All data obtained are then
combined into a single dataframe and returned.

Parameters included in AirNow data include at least the following list:
\enumerate{
\item{BARPR}
\item{BC}
\item{CO}
\item{NO}
\item{NO2}
\item{NO2Y}
\item{NO2X}
\item{NOX}
\item{NOOY}
\item{OC}
\item{OZONE}
\item{PM10}
\item{PM2.5}
\item{PRECIP}
\item{RHUM}
\item{SO2}
\item{SRAD}
\item{TEMP}
\item{UV-AETH}
\item{WD}
\item{WS}
}

Passing a vector of one ore more of the above names as the \code{parameters} argument will cause the resulting 
dataframe to be filtered to contain only records for those parameters.
}
\note{
As of 2016-12-27, it appears that hourly data are available only for 2016 and
not for earlier years.
}
\examples{
\dontrun{
df <- airnow_downloadData("PM2.5", 2016070112, hours=24)
}
}
\seealso{
\link{airnow_createDataDataframes}

\link{airnow_downloadHourlyData}
}
\keyword{AirNow}

