% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addGoogleElevation.R
\name{addGoogleElevation}
\alias{addGoogleElevation}
\title{Add Elevation Data to a Dataframe}
\usage{
addGoogleElevation(
  df,
  lonVar = "longitude",
  latVar = "latitude",
  existingMeta = NULL
)
}
\arguments{
\item{df}{dataframe with geolocation information (\emph{e.g.} those created by \code{wrcc_qualityControl()} or \code{airsis_qualityControl})}

\item{lonVar}{name of longitude variable in the incoming dataframe}

\item{latVar}{name of the latitude variable in the incoming dataframe}

\item{existingMeta}{existing 'meta' dataframe from which to obtain metadata for known monitor deployments}
}
\value{
Input dataframe with (possibly) additional column: \code{elevation}.
}
\description{
Google APIs are used to determine elevation associated with the locations specified by the
\code{lonVar} and \code{latVar} columns of the incoming dataframe.

Address information is obtained by using the \pkg{ggmap} package.
}
\references{
\url{https://developers.google.com/maps/documentation/elevation/intro}
}
\keyword{internal}
