% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addClustering.R
\name{addClustering}
\alias{addClustering}
\title{Add clustering information to a dataframe}
\usage{
addClustering(
  tbl,
  clusterDiameter = 1000,
  lonVar = "longitude",
  latVar = "latitude",
  maxClusters = 50,
  flagAndKeep = FALSE
)
}
\arguments{
\item{tbl}{tibble with geolocation information (\emph{e.g.} created by \code{wrcc_qualityControl()} or \code{airsis_qualityControl})}

\item{clusterDiameter}{diameter in meters used to determine the number of clusters (see description)}

\item{lonVar}{name of longitude variable in the incoming tibble}

\item{latVar}{name of the latitude variable in the incoming tibble}

\item{maxClusters}{maximum number of clusters to try}

\item{flagAndKeep}{flag, rather then remove, bad data during clustering}
}
\value{
Input tibble with additional columns: \code{deploymentID, medoidLon, mediodLat}.
}
\description{
Clustering is used to assign individual measurements to deployment locations.

The value of \code{clusterRadius} is compared with the output of \code{cluster::pam(...)$clusinfo[,'av_diss']}
to determine the number of clusters.
}
\references{
\href{https://working-with-data.mazamascience.com/2021/07/15/when-k-means-clustering-fails/}{When k-means clustering fails}
}
\keyword{internal}
