% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pspaceMisc.R
\name{pathDistances}
\alias{pathDistances}
\title{Calculate a pathway space distance between two vectors.}
\usage{
pathDistances(gdist, from, to, nperm = 1000, verbose = TRUE)
}
\arguments{
\item{gdist}{A distance matrix computed by the igraph's \code{distances} 
function. Rows and columns must be named with vertex labels as listed in
the 'igraph' object.}

\item{from}{A vector with valid vertex names.}

\item{to}{A vector with valid vertex names.}

\item{nperm}{Number of permutations.}

\item{verbose}{A single logical value specifying to display detailed 
messages (when \code{verbose=TRUE}) or not (when \code{verbose=FALSE}).}
}
\value{
A list with pathway space distances and a 'ggplot' object.
}
\description{
Calculate a pathway space distance between two vectors.
}
\examples{

# Load a vertex-wise distance matrix (distance between nodes in a graph)
data("gdist.toy", package = "PathwaySpace")

# Get two vertex lists
from <- sample(colnames(gdist.toy), 50)
to <- sample(colnames(gdist.toy), 50)

# Calculate distances between lists, and between random lists
res <- pathDistances(gdist.toy, from, to)
names(res)
# "p_dist"  "z_score"

}
\seealso{
\code{\link{plotPathwaySpace}}
}
