% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/addDemographics.R
\name{addFutureObservation}
\alias{addFutureObservation}
\title{Compute the number of days till the end of the observation period at a
certain date}
\usage{
addFutureObservation(
  x,
  cdm,
  indexDate = "cohort_start_date",
  futureObservationName = "future_observation",
  tablePrefix = NULL
)
}
\arguments{
\item{x}{Table with individuals in the cdm.}

\item{cdm}{Object that contains a cdm reference. Use CDMConnector to obtain a
cdm reference.}

\item{indexDate}{Variable in x that contains the date to compute the future
observation.}

\item{futureObservationName}{name of the new column to be added}

\item{tablePrefix}{The stem for the permanent tables that will
be created. If NULL, temporary tables will be used throughout.}
}
\value{
cohort table with added column containing future observation of the
individuals
}
\description{
Compute the number of days till the end of the observation period at a
certain date
}
\examples{
\donttest{
library(DBI)
library(duckdb)
library(tibble)
library(PatientProfiles)
cohort1 <- tibble::tibble(
  cohort_definition_id = c("1", "1", "1"),
  subject_id = c("1", "2", "3"),
  cohort_start_date = c(
    as.Date("2010-03-03"),
    as.Date("2010-03-01"),
    as.Date("2010-02-01")
  ),
  cohort_end_date = c(
    as.Date("2015-01-01"),
    as.Date("2013-01-01"),
    as.Date("2013-01-01")
  )
)

obs_1 <- tibble::tibble(
  observation_period_id = c("1", "2", "3"),
  person_id = c("1", "2", "3"),
  observation_period_start_date = c(
    as.Date("2010-02-03"),
    as.Date("2010-02-01"),
    as.Date("2010-01-01")
  ),
  observation_period_end_date = c(
    as.Date("2014-01-01"),
    as.Date("2012-01-01"),
    as.Date("2012-01-01")
  )
)

cdm <-
  mockPatientProfiles(
    seed = 1,
    cohort1 = cohort1,
    observation_period = obs_1
  )

result <- cdm$cohort1 \%>\% addFutureObservation(cdm)
}
}
