% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotSummarised.R
\name{plotCohortTiming}
\alias{plotCohortTiming}
\title{Plot summariseCohortTiming results.}
\usage{
plotCohortTiming(
  result,
  type = "boxplot",
  facetBy = NULL,
  color = c("cohort_name_reference", "cohort_name_comparator"),
  timingLabel = "{cohort_name_reference}; {cohort_name_comparator}",
  uniqueCombinations = TRUE
)
}
\arguments{
\item{result}{A summariseCohortTiming result.}

\item{type}{Type of desired formatted table, possibilities are "boxplot" and
"density".}

\item{facetBy}{Vector of column names  in the cohort_overlap table for faceting the
ggplot object.}

\item{color}{Vector of column names to distinct by colors.}

\item{timingLabel}{A glue expression to identify each plotted cohort
overlap.}

\item{uniqueCombinations}{If TRUE, only unique combinations of reference and
comparator plots will be plotted.}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- PatientProfiles::mockPatientProfiles()
timing <- summariseCohortTiming(cdm$cohort2)
plotCohortTiming(timing)
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
