% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summariseCohortTiming.R
\name{summariseCohortTiming}
\alias{summariseCohortTiming}
\title{Summarise cohort timing}
\usage{
summariseCohortTiming(
  cohort,
  cohortId = NULL,
  strata = list(),
  restrictToFirstEntry = TRUE,
  timing = c("min", "q25", "median", "q75", "max"),
  density = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{cohortId}{Vector of cohort definition ids to include, if NULL, all
cohort definition ids will be used.}

\item{strata}{List of the stratifications within each group to be considered.
Must be column names in the cohort table provided.}

\item{restrictToFirstEntry}{If TRUE only an individual's first entry per
cohort will be considered. If FALSE all entries per individual will be
considered.}

\item{timing}{Summary statistics for timing.}

\item{density}{Get data for density plot.}
}
\value{
A summarised result.
}
\description{
Summarise cohort timing
}
\examples{
\donttest{
library(PatientProfiles)
cdm <- PatientProfiles::mockPatientProfiles()
results <- summariseCohortTiming(cdm$cohort2)
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
