% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conductance.R
\name{conductance}
\alias{conductance}
\title{compute win-loss probabilities}
\usage{
conductance(conf, maxLength, alpha = NULL, beta = 1, strict = FALSE)
}
\arguments{
\item{conf}{a matrix of conf.mat class. An N-by-N conflict matrix whose \code{(i,j)}th element is the number of times i defeated j.}

\item{maxLength}{an integer greater than 1 and less than 7, indicating the maximum length of paths to identify.}

\item{alpha}{a positive integer that 
reflects the influence of an observed win/loss interaction 
on an underlying win-loss probability. 
It is used in the calculation of the posterior distribution 
for the win-loss probability of \code{i} over \code{j}: \eqn{Beta(\alpha c_{i,j} +\beta, c_{i,j}+\beta)}. 
In the absence of expertise to accurately estimate alpha, 
it is estimated from the data.}

\item{beta}{a positive numeric value that, like alpha, 
reflects the influence of an observed win/loss interaction 
on an underlying win-loss probability. 
Both \eqn{\alpha} and \eqn{\beta} are chosen such that \eqn{((\alpha + \beta)/(\alpha + 2\beta))^2} is 
equal to the order-1 transitivity of the observed network. 
Therefore, \eqn{\beta} is commonly set to 1.}

\item{strict}{a logical vector of length 1. It is used in transitivity definition for alpha estimation. 
It should be set to TRUE when a transitive triangle is defined as all pathways in the triangle go to the same direction;
it should be set to FALSE when a transitive triangle is defined as PRIMARY pathways in the triangle go to the same direction.
Strict = FALSE by default.}
}
\value{
a list of two elements. 

 \item{imputed.conf}{An N-by-N conflict matrix whose \code{(i,j)}th element is the 
   'effective' number of wins of \code{i} over \code{j}.}
   
 \item{p.hat}{An N-by-N numeric matrix whose \code{(i,j)}th element is the estimated 
     win-loss probability. 
     Three functions (\code{\link{valueConverter}}, \code{\link{individualDomProb}}, and \code{\link{dyadicLongConverter}}) are provided to convert win-loss probability 
     into other formats that are easier for further analysis of win-loss probability. }
}
\description{
\code{conductance} compute win-loss probabilities for all possible pairs
 based upon the combined information from directed wins/losses and 
 indirect win/loss pathways from the network.
}
\details{
This function performs two major steps. 
First, repeated random walks through the empirical network 
identify all possible directed win-loss pathways 
between each pair of nodes in the network. 
Second, the information from both direct wins/losses and 
pathways of win/loss interactions are combined into an estimate of 
the underlying probability of \code{i} over \code{j}, for all \code{ij} pairs.
}
\examples{
# convert an edgelist to conflict matrix
confmatrix <- as.conflictmat(sampleEdgelist)
# find win-loss probability matrix
perm2 <- conductance(confmatrix, 2, strict = FALSE)
perm2$imputed.conf
perm2$p.hat
}
\references{
Fushing H, McAssey M, Beisner BA, McCowan B. 2011. 
Ranking network of a captive rhesus macaque society: a sophisticated corporative kingdom. 
PLoS ONE 6(3):e17817.
}
\seealso{
\code{\link{as.conflictmat}}, \code{\link{findIDpaths}}, \code{\link{transitivity}}, \code{\link{simRankOrder}}
}
