% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chart.RollingPerformance.R
\name{chart.RollingPerformance}
\alias{chart.RollingPerformance}
\title{wrapper to create a chart of rolling performance metrics in a line chart}
\usage{
chart.RollingPerformance(
  R,
  width = 12,
  FUN = "Return.annualized",
  ...,
  ylim = NULL,
  main = NULL,
  fill = NA
)
}
\arguments{
\item{R}{an xts, vector, matrix, data frame, timeSeries or zoo object of
asset returns}

\item{width}{number of periods to apply rolling function window over}

\item{FUN}{any function that can be evaluated using a single set of returns
(e.g., rolling \code{\link{CAPM.beta}} won't work, but
\code{\link{Return.annualized}} will)}

\item{\dots}{any other passthru parameters to \code{\link{plot}} or the
function specified}

\item{ylim}{set the y-axis limit, same as in \code{\link{plot}}}

\item{main}{set the chart title, same as in \code{\link{plot}}}

\item{fill}{a three-component vector or list (recycled otherwise) providing 
filling values at the left/within/to the right of the data range. See the 
fill argument of \code{\link{na.fill}} for details.}
}
\description{
A wrapper to create a chart of rolling performance metrics in a line chart
}
\details{
The parameter \code{na.pad} has been deprecated; use \code{fill = NA} instead of \code{na.pad = TRUE}, 
or \code{fill = NULL} instead of \code{na.pad = FALSE}.
}
\examples{
if(!( Sys.info()[['sysname']]=="Windows") ){
# if on Windows, cut and paste this example
data(edhec)
chart.RollingPerformance(edhec[, 1:3], width = 24)
chart.RollingPerformance(edhec[, 1:3], 
		FUN = 'mean', width = 24, colorset = rich8equal, 
		lwd = 2, legend.loc = "topleft", 
		main = "Rolling 24-Month Mean Return")
chart.RollingPerformance(edhec[, 1:3], 
		FUN = 'SharpeRatio.annualized', width = 24, 
		colorset = rich8equal, lwd = 2, legend.loc = "topleft", 
		main = "Rolling 24-Month Sharpe Ratio")
}

}
\seealso{
\code{\link{charts.RollingPerformance}},
\code{\link[zoo]{rollapply}}
}
\author{
Peter Carl
}
