% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/downloadSignatures.R
\name{downloadSignatures}
\alias{downloadSignatures}
\title{Download Drug Signatures}
\usage{
downloadSignatures(name = c("CGP", "CCLE", "CMAP"), gene = TRUE,
  saveDir = file.path(".", "PSets", "Sigs"), myfn = NULL, verbose = TRUE)
}
\arguments{
\item{name}{\code{Character} string, the name of the PhamracoSet for which to
download signatures. The available options are CGP, CCLE, and CMAP}

\item{gene}{\code{bool} Should the signatures be downloaded at the gene level
(TRUE) or probe level (FALSE). Defaults to TRUE.}

\item{saveDir}{\code{Character} string with the folder path where the
PharmacoSet should be saved. Defaults to \code{"./PSets/Sigs/"}. Will create
directory if it does not exist.}

\item{myfn}{\code{character} string, the file name to save the dataset under}

\item{verbose}{\code{bool} Should status message be printed during download.
Defaults to TRUE.}
}
\description{
This function allows you to download an array of drug signatures, as would be
computed by the \code{drugPerturbationSig} and \code{drugSensitivitySig}
functions, for available perturbation and sensitivity
\code{PharmacoSets} respectively. This function allows the user to skip these very
lengthy calculation steps for the datasets available, and start their
analysis from the already computed signatures
}

