% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/drugSensitivitySig.R
\name{drugSensitivitySig}
\alias{drugSensitivitySig}
\title{Creates a signature representing the association between gene expression (or
other molecular profile) and drug dose response, for use in drug sensitivity
analysis.}
\usage{
drugSensitivitySig(pSet, mDataType, drugs, features,
  sensitivity.measure = c("ic50_published", "auc_published",
  "ic50_recomputed", "auc_recomputed", "auc_recomputed_star"),
  molecular.summary.stat = c("mean", "median", "first", "last", "or", "and"),
  sensitivity.summary.stat = c("mean", "median", "first", "last"),
  returnValues = c("estimate", "pvalue", "fdr"), sensitivity.cutoff,
  nthread = 1, verbose = TRUE)
}
\arguments{
\item{pSet}{[PharmacoSet] a PharmacoSet of the perturbation experiment type}

\item{mDataType}{[character] which one of the molecular data types to use
in the analysis, out of dna, rna, rnaseq, snp, cnv}

\item{drugs}{[character] a vector of drug names for which to compute the
signatures. Should match the names used in the PharmacoSet.}

\item{features}{[character] a vector of features for which to compute the
signatures. Should match the names used in correspondant molecular data in PharmacoSet.}

\item{sensitivity.measure}{[character] which measure of the drug dose
sensitivity should the function use for its computations? The current
choices are 'ic50_published', 'auc_published', 'ic50_recomputed',
'auc_recomputed'.}

\item{molecular.summary.stat}{What summary statistic should be used to
summarize duplicates for cell line molecular profile measurements?}

\item{sensitivity.summary.stat}{What summary statistic should be used to
summarize duplicates for cell line sensitivity measurements?}

\item{returnValues}{[character] Which of estimate, t-stat, p-value and fdr
should the function return for each gene drug pair?}

\item{sensitivity.cutoff}{Allows to provide upper and lower bounds to
sensitivity measures in the cases where the values exceed physical values
due to numerical or other errors.}

\item{nthread}{[numeric] if multiple cores are available, how many cores
should the computation be parallelized over?}

\item{verbose}{[boolean] 'TRUE' if the warnings and other infomrative message shoud be displayed}
}
\value{
[list] a 3D array with genes in the first dimension, drugs in the
  second, and return values in the third.
}
\description{
Given a Pharmacoset of the sensitivity experiment type, and a list of drugs,
the function will compute a signature for the effect gene expression on the
molecular profile of a cell. The function returns the estimated coefficient,
the t-stat, the p-value and the false discovery rate associated with that
coefficient, in a 3 dimensional array, with genes in the first direction,
drugs in the second, and the selected return values in the third.
}
\examples{
data(GDSCsmall)
drug.sensitivity <- drugSensitivitySig(GDSCsmall, mDataType="rna",
             nthread=1, features = featureNames(GDSCsmall, "rna")[1])
print(drug.sensitivity)
}

