% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parsimonyNumber.R
\name{compute_state_filter}
\alias{compute_state_filter}
\title{List of potential daughter states when parent is in state k.}
\usage{
compute_state_filter(cost, k)
}
\arguments{
\item{cost}{a (ndaughters) x (nclus) matrix of the cost of each state for the 
daughters nodes.}

\item{k}{the parental state considered.}
}
\value{
A (ndaughters) x (nclus) binary matrix indicating the admissible
states for the daughters node when parent node is in state k.
}
\description{
\code{compute_state_filter} compute the admissible daughters states, i.e. states that 
realize the minimum cost for the tree parent -> daughter -> subtree(daughter), when 
the parent node is in state k.
}
\details{
This function is used in functions \code{parsimonyNumber} and \code{enumerate_parsimony}.
}
\keyword{internal}

